<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

/**
 * Main class handling JoomSEF's cache
 *
 */
class sefCache
{
    var $cacheUrl           = array();
    var $cacheItemid        = array();
    var $cacheHit           = array();
    var $cacheMetaTitle     = array();
    var $cacheMetaDesc      = array();
    var $cacheMetaKey       = array();
    var $cacheMetaLang      = array();
    var $cacheMetaRobots    = array();
    var $cacheMetaGoogle    = array();

    var $cacheLoaded = false;
    var $cacheFile = null;
    var $maxSize;
    var $minHits;

    /**
     * Sets the main variables and loads the cache from disk
     *
     * @param int $maxSize
     * @param int $minHits
     * @return sefCache
     */
    function sefCache($maxSize, $minHits)
    {
        global $mosConfig_absolute_path;

        $this->maxSize = $maxSize;
        $this->minHits = $minHits;
        $this->cacheFile = $mosConfig_absolute_path.'/components/com_sef/cache/cache.php';

        $this->loadCache();
    }

    /**
     * Loads the cache from disk to memory
     *
     */
    function loadCache()
    {
        // Is cache already loaded?
        if ($this->cacheLoaded) return;

        if (file_exists($this->cacheFile)) {
            // Load the cache from disk
            include_once($this->cacheFile);
        }
        else {
            // Set the empty cache arrays
            if (!is_dir(dirname($this->cacheFile))) {
                mkdir(dirname($this->cacheFile));
            }

            $url            = array();
            $hit            = array();
            $Itemids        = array();
            $metaTitles     = array();
            $metaDescs      = array();
            $metaKeys       = array();
            $metaLangs      = array();
            $metaRobots     = array();
            $metaGoogles    = array();
        }

        // Assign the arrays to cache variables
        $this->cacheUrl         = $url;
        $this->cacheItemid      = $Itemids;
        $this->cacheHit         = $hit;
        $this->cacheMetaTitle   = $metaTitles;
        $this->cacheMetaDesc    = $metaDescs;
        $this->cacheMetaKey     = $metaKeys;
        $this->cacheMetaLang    = $metaLangs;
        $this->cacheMetaRobots  = $metaRobots;
        $this->cacheMetaGoogle  = $metaGoogles;

        $this->cacheLoaded = true;
    }

    /**
     * Helper function for saving an array into includeable file
     * Returns the string ready for writing to disk
     *
     * @param array $array
     * @param string $arrayName
     * @return string
     */
    function saveArray(&$array, $arrayName)
    {
        $str = "\n";
        $str .= '$'.$arrayName.'=array();';
        if( count($array) > 0 ) {
            reset($array);
            foreach($array as $sef => $val) {
                $str .= "\n";
                $str .= '$'.$arrayName.'[\''.$sef.'\']=\''.str_replace(array('\\', '\''), array('\\\\', '\\\''), $val).'\';';
            }
        }

        return $str;
    }

    /**
     * Saves the cache arrays to disk
     *
     */
    function saveCache()
    {
        global $sefConfig;
        
        // Security check
        $cache = '<?php
if (!defined(\'_VALID_MOS\')) die(\'Direct Access to this location is not allowed.\');';

        // Add all the arrays
        $cache .= $this->saveArray($this->cacheUrl, 'url');
        $cache .= $this->saveArray($this->cacheItemid, 'Itemids');
        $cache .= $this->saveArray($this->cacheHit, 'hit');
        $cache .= $this->saveArray($this->cacheMetaTitle, 'metaTitles');
        $cache .= $this->saveArray($this->cacheMetaDesc, 'metaDescs');
        $cache .= $this->saveArray($this->cacheMetaKey, 'metaKeys');
        $cache .= $this->saveArray($this->cacheMetaLang, 'metaLangs');
        $cache .= $this->saveArray($this->cacheMetaRobots, 'metaRobots');
        $cache .= $this->saveArray($this->cacheMetaGoogle, 'metaGoogles');

        $cache .= "\n?>";

        // Write the cache to disk
        if( !$sefConfig->cacheFLock ) {
            // Don't use flock
            if( !$this->lock(10) ) {
                return;
            }
        }
        
        $cachefile = @fopen($this->cacheFile, 'wb');
        if ($cachefile) {
            
            if( $sefConfig->cacheFLock ) {
                // Use flock
                if( !flock($cachefile, LOCK_EX) ) {
                    @fclose($cachefile);
                    return;
                }
            }
            
            @fwrite($cachefile, $cache);
            @fclose($cachefile);
        }
        
        if( !$sefConfig->cacheFLock ) {
            // Don't use flock
            $this->unlock();
        }
    }

    /**
     * Locks the cache file in an OS independent way
     * Returns true if lock was acquired, false otherwise
     *
     * @return boolean
     */
    function lock($timeout = 10)
    {
        $lockfile = $this->cacheFile.'.lck';

        // Try to read the timeout information from the lock
        $t = @file($lockfile);
        
        // Try to create the lock
        if( !$this->lockSet($timeout) ) {
            // Check the lock timeout
            if( $t !== false ) {
                $t = intval(trim(implode($t)));
                if( time() >= $t ) {
                    // Remove the lock
                    @unlink($lockfile);
                    
                    // Try to create the lock
                    return $this->lockSet($timeout);
                }
            }
            
            return false;
        }
        
        return true;
    }
    
    /**
     * Creates the lock
     *
     * @param  int $timeout
     * @return boolean
     */
    function lockSet($timeout)
    {
        $lockfile = $this->cacheFile.'.lck';
        
        $f = @fopen($lockfile, 'x');
        if( $f !== false )  {
            // Save the timeout information
            $t = time() + intval($timeout);
            if( false === @fwrite($f, $t) ) {
                @fclose($f);
                @unlink($lockfile);
                return false;
            }
            
            return @fclose($f);
        }
        
        return false;
    }
    
    /**
     * Unlocks the cache file in an OS independent way
     *
     */
    function unlock()
    {
        $lockfile = $this->cacheFile.'.lck';
        @unlink($lockfile);
    }
    
    /**
     * Tries to find a nonSEF URL corresponding with given SEF URL
     * If updateHits is set the function will increase the cached URL hit count
     *
     * @param string $sef
     * @param boolean $updateHits
     * @return object
     */
    function getNonSefUrl($sef, $updateHits = true)
    {
        // Load the cache if needed
        if (!$this->cacheLoaded) $this->loadCache();

        // Does the item exist in cache?
        if (isset($this->cacheUrl[$sef])) {
            // Create the object to be returned
            $row = new stdClass();
            $row->oldurl     = $sef;
            $row->newurl     = $this->cacheUrl[$sef];
            $row->cpt        = $this->cacheHit[$sef];
            $row->Itemid     = (isset($this->cacheItemid[$sef])     ? $this->cacheItemid[$sef] : '' );
            $row->metatitle  = (isset($this->cacheMetaTitle[$sef])  ? $this->cacheMetaTitle[$sef] : '' );
            $row->metadesc   = (isset($this->cacheMetaDesc[$sef])   ? $this->cacheMetaDesc[$sef] : '' );
            $row->metakey    = (isset($this->cacheMetaKey[$sef])    ? $this->cacheMetaKey[$sef] : '' );
            $row->metalang   = (isset($this->cacheMetaLang[$sef])   ? $this->cacheMetaLang[$sef] : '' );
            $row->metarobots = (isset($this->cacheMetaRobots[$sef]) ? $this->cacheMetaRobots[$sef] : '' );
            $row->metagoogle = (isset($this->cacheMetaGoogle[$sef]) ? $this->cacheMetaGoogle[$sef] : '' );

            // Update hits if set to
            if($updateHits) {
                $this->cacheHit[$sef]++;
                $this->saveCache();
            }

            return $row;
        } else {
            // Cache record not found
            return false;
        }
    }

    /**
     * Tries to find a SEF URL corresponding with given nonSEF URL
     *
     * @param string $nonsef
     * @param string $Itemid
     * @return string
     */
    function getSefUrl($nonsef, $Itemid = null)
    {
        global $sefConfig;

        // Load the cache if needed
        if( !$this->cacheLoaded )   $this->LoadCache();

        // Check if non-sef url doesn't contain Itemid
        $vars = array();
        parse_str(str_replace('index.php?', '', $nonsef), $vars);
        if( is_null($Itemid) && strpos($nonsef, 'Itemid=') ) {
            if( isset($vars['Itemid']) )    $Itemid = $vars['Itemid'];
            $nonsef = SEFTools::RemoveVariable($nonsef, 'Itemid');
        }

        // Get the ignoreSource parameter
        if( isset($vars['option']) ) {
            $params = SEFTools::getExtParams($vars['option']);
            $extIgnore = $params->get('ignoreSource', 2);
        } else {
            $extIgnore = 2;
        }
        $ignoreSource = ($extIgnore == 2 ? $sefConfig->ignoreSource : $extIgnore);

        if( $ignoreSource || is_null($Itemid) ) {
            // Search without Itemid
            if (($key = array_search($nonsef, $this->cacheUrl)) === FALSE ) {
                return false;
            } else {
                return $key;
            }
        }
        else {
            // Search with Itemid
            // Get all sef urls matching non-sef url
            $keys = array_keys($this->cacheUrl, $nonsef);
            if (count($keys) > 0) {
                // Try to find the key with corresponding Itemid
                foreach ($keys as $key) {
                    if (isset($this->cacheItemid[$key]) && ($this->cacheItemid[$key] == $Itemid)) {
                        return $key;
                    }
                }
            }
            return false;
        }
    }

    /**
     * Adds the URL to cache
     *
     * @param string $nonsef
     * @param string $sef
     * @param int $hits
     * @param string $Itemid
     * @param string $metatitle
     * @param string $metadesc
     * @param string $metakey
     * @param string $metalang
     * @param string $metarobots
     * @param string $metagoogle
     */
    function addUrl($nonsef, $sef, $hits, $Itemid = '', $metatitle = '', $metadesc = '', $metakey = '', $metalang = '', $metarobots = '', $metagoogle = '')
    {
        // Check if URL's hits count is enough to be stored
        if ($hits < $this->minHits)    return;

        // Check the cache size
        if (count($this->cacheUrl) < $this->maxSize) {
            // OK, we can add the URL to the end
            $this->cacheUrl[$sef] = $nonsef;
            $this->cacheHit[$sef] = $hits;
            if ($Itemid     != '')     $this->cacheItemid[$sef] = $Itemid;
            if ($metatitle  != '')  $this->cacheMetaTitle[$sef] = $metatitle;
            if ($metadesc   != '')   $this->cacheMetaDesc[$sef] = $metadesc;
            if ($metakey    != '')    $this->cacheMetaKey[$sef] = $metakey;
            if ($metalang   != '')   $this->cacheMetaLang[$sef] = $metalang;
            if ($metarobots != '') $this->cacheMetaRobots[$sef] = $metarobots;
            if ($metagoogle != '') $this->cacheMetaGoogle[$sef] = $metagoogle;

            // Sort the cache by hit count
            asort($this->cacheHit, SORT_NUMERIC);

            // Save the cache to disk
            $this->saveCache();
        }
        else {
            // Get the URL with minimum hits count
            reset($this->cacheHit);
            list($key, $value) = each($this->cacheHit);

            // Check if new URL is more often used
            if ($hits > $value) {
                // It is, let's change it
                unset($this->cacheHit[$key]);
                unset($this->cacheUrl[$key]);
                unset($this->cacheItemid[$key]);
                unset($this->cacheMetaTitle[$sef]);
                unset($this->cacheMetaDesc[$sef]);
                unset($this->cacheMetaKey[$sef]);
                unset($this->cacheMetaLang[$sef]);
                unset($this->cacheMetaRobots[$sef]);
                unset($this->cacheMetaGoogle[$sef]);

                $this->cacheUrl[$sef] = $nonsef;
                $this->cacheHit[$sef] = $hits;
                if ($Itemid != '')     $this->cacheItemid[$sef]      = $Itemid;
                if ($metatitle != '')  $this->cacheMetaTitle[$sef]   = $metatitle;
                if ($metadesc != '')   $this->cacheMetaDesc[$sef]    = $metadesc;
                if ($metakey != '')    $this->cacheMetaKey[$sef]     = $metakey;
                if ($metalang != '')   $this->cacheMetaLang[$sef]    = $metalang;
                if ($metarobots != '') $this->cacheMetaRobots[$sef]  = $metarobots;
                if ($metagoogle != '') $this->cacheMetaGoogle[$sef]  = $metagoogle;

                asort($this->cacheHit, SORT_NUMERIC);

                $this->saveCache();
            }
        }
    }
}
?>
