<?php
/**
 * Community Builder SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

// Returns user name for given id
if( !function_exists('sefCBGetUser')) {
    function sefCBGetUser($id) {
        global $database;
                
        $database->setQuery("SELECT `username` FROM `#__users` WHERE `id` = $id");
        return $database->loadResult();
    }
}

global $sefConfig, $mosConfig_absolute_path, $mosConfig_lang;

// Include community builder language file
$path = $mosConfig_absolute_path.'/components/com_comprofiler/plugin/language';
if( file_exists($path.'/'.$mosConfig_lang.'/'.$mosConfig_lang.'.php') ) {
  include_once( $path.'/'.$mosConfig_lang.'/'.$mosConfig_lang.'.php' );
} else {
    include_once( $path.'/default_language/default_language.php' );
}

// Extract variables
extract($vars);
$title = array();

$title[] = getMenuTitle(@$option, @$task, @$Itemid);

if( isset($task) ) {
    switch($task) {
        case 'userProfile':
            $title[] = _UE_PROFILE;
            $title[] = sefCBGetUser($user);
            unset($task);
            break;
            
        case 'emailUser':
        case 'banProfile':
        case 'reportUser':
            $tasks = array( 'emailUser' => _UE_EMAIL,
                            'banProfile' => _UE_BANPROFILE,
                            'reportUser' => _UE_REPORTUSER );
            $title[] = $tasks[$task];
            $title[] = sefCBGetUser($uid);
            unset($task);
            break;
                        
        case 'acceptConnection':
        case 'addConnection':
        case 'removeConnection':
            $tasks = array( 'acceptConnection' => _UE_ACCEPTCONNECTION,
                            'addConnection' => _UE_ADDCONNECTION,
                            'removeConnection' => _UE_REMOVECONNECTION );
            $title[] = $tasks[$task];
            $title[] = sefCBGetUser($connectionid);
            unset($task);
            break;
            
        case 'userAvatar':
            if( isset($do) && ($do == 'deleteavatar') )
                $title[] = _UE_DELETE_AVATAR;
            else 
                $title[] = _UE_AVATAR;
            unset($task);
            break;
            
        case 'manageConnections':
        case 'saveConnections':
        case 'teamCredits':
        case 'userDetails':
            $tasks = array( 'manageConnections' => _UE_MANAGECONNECTIONS,
                            'saveConnections' => _UE_UPDATE,
                            'teamCredits' => _UE_MENU_ABOUT_CB,
                            'userDetails' => _UE_USERPROFILE );
            $title[] = $tasks[$task];
            unset($task);
            break;
    }
    
    if( !$sefConfig->appendNonSef && isset($tab) )
        $title[] = $tab;
}

if (count($title) > 0) {
    $nonSefVars = array();
    if( isset($tab) )   $nonSefVars['tab'] = $tab;
    $string = sef_404::sefGetLocation($string, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
}
?>
