<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

// Ensure that user has access to this function.
if (!($acl->acl_check('administration', 'edit', 'users', $my->usertype, 'components', 'all')
| $acl->acl_check('administration', 'edit', 'users', $my->usertype, 'components', 'com_sef'))) {
    mosRedirect('index2.php', _NOT_AUTH);
}

$sefAdminPath = $GLOBALS['mosConfig_absolute_path'].'/administrator/components/com_sef/';

// Get the right language file.
if (file_exists($sefAdminPath.'language/'.$mosConfig_lang.'.php')) {
    include($sefAdminPath.'language/'.$mosConfig_lang.'.php');
}
else {
    include($sefAdminPath.'language/english.php');
}

// Setup paths.
$sef_config_class = $sefAdminPath.'sef.class.php';
$sef_config_file  = $sefAdminPath.'config.sef.php';

require_once($mainframe->getPath('admin_html'));
require_once($mainframe->getPath('class'));

// Make sure class was loaded.
if (!class_exists('SEFConfig')) {
    if (is_readable($sef_config_class)) require_once($sef_config_class);
    else die(_COM_SEF_NOREAD."($sef_config_class)<br />"._COM_SEF_CHK_PERMS);
}

$cid    = mosGetParam($_REQUEST, 'cid', array(0));
$sortby = mosGetParam($_REQUEST, 'sortby', 0);
if (!is_array($cid)) $cid = array(0);

$sefConfig = new SEFConfig();

// Action switch.
switch ($task) {
    case 'cancel': {
        cancelSEF($option);
        break;
    }
    case 'edit': {
        editSEF($cid[0], $option);
        break;
    }
    case 'help': {
        showNavigationBar(_COM_SEF_TITLE_SUPPORT);
        HTML_sef::help();
        break;
    }
    case 'info': {
        showNavigationBar(_COM_SEF_TITLE_INFO);
        include 'components/com_sef/readme.inc.html';
        break;
    }
    case 'new': {
        editSEF(0, $option);
        break;
    }
    case 'purge': {
        purge($option, @$ViewModeId);
        break;
    }
    case 'remove': {
        removeSEF($cid, $option);
        break;
    }
    case 'save': {
        if ($section == 'config') saveConfig();
        else saveSEF($option);
        break;
    }
    case 'saveconfig': {
        saveConfig();
        break;
    }
    case 'showconfig': {
        showNavigationBar(_COM_SEF_TITLE_CONFIG);
        showConfig($option);
        break;
    }
    case 'view': {
        viewSEF($option, @$ViewModeId);
        break;
    }
    case 'import_export': {
        showNavigationBar(_COM_SEF_IMPORT_EXPORT);
        HTML_sef::import_export();
        break;
    }
    case 'import': {
        $userfile = mosGetParam($_FILES, 'userfile', null);
        if (!$userfile) {
            echo '<p class="error">ERROR UPLOADING FILE</p>';
            exit();
        }
        else{
            import_custom($userfile);
            break;
        }
    }
    case 'export': {
        export_custom('joomsef_custom_urls.sql');
        break;
    }
    case 'dwnld': {
        $data =  $sefConfig->saveConfig(1);
        $trans_tbl = get_html_translation_table(HTML_ENTITIES);
        $trans_tbl = array_flip($trans_tbl);
        $data =strtr($data, $trans_tbl);
        output_attachment('config.sef.php',$data);
        exit();
    }
    case 'showupgrade': {
        // Shows the form for upgrade source selection (server or local package)
        showNavigationBar(_COM_SEF_TITLE_UPGRADE);
        HTML_sef::show_upgrade();
        break;
    }
    case 'upgrade': {
        // Upgrades JoomSEF from selected source
        //require_once($mosConfig_absolute_path.'/administrator/components/com_installer/installer.class.php');
        //upgrade();
        include_once($sefAdminPath.'installer/upgrade.php');
        break;
    }
    case 'installext': {
        showNavigationBar(_COM_SEF_TITLE_INSTALL_EXT);
        include_once($sefAdminPath.'installer/sefext.php');
        HTML_installer::showInstallForm(_COM_SEF_TITLE_INSTALL_NEW_EXT, $option, 'sef_ext', '', dirname(__FILE__));
        HTML_sefext::showWritable();
        showInstalledExts($option);
        break;
    }
    case 'uploadfile':
    case 'installfromdir':
    case 'uninstallext': {
        include_once($sefAdminPath.'installer/installer.php');
        break;
    }
    default: {
        showNavigationBar();
        include_once($sefAdminPath.'joomsef_cpanel.php');
        include_once($sefAdminPath.'installer/sefext.php');
        echo('<br />');
        showInstalledExts($option);
        break;
    }
}

/**
 * List the records.
 *
 * @param string The current GET/POST option
 * @param int The mode of view 0=
 */
function viewSEF($option, $ViewModeId = 0)
{
    global $database, $mainframe, $mosConfig_list_limit;

    $catid = $mainframe->getUserStateFromRequest("catid{$option}", 'catid', 0);
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    $ViewModeId = $mainframe->getUserStateFromRequest("viewmode{$option}", 'viewmode', 3);
    $SortById = $mainframe->getUserStateFromRequest("SortBy{$option}", 'sortby', 0);
    $ComponentFilter = $mainframe->getUserStateFromRequest("ComFilter{$option}", 'comFilter', '');
    $FilterSEF = $mainframe->getUserStateFromRequest("FilterSEF{$option}", 'filterSEF', '');
    $FilterReal = $mainframe->getUserStateFromRequest("FilterReal{$option}", 'filterReal', '');

    if ($ViewModeId == 1) {
        $where = "`dateadd` > '0000-00-00' AND `newurl` = '' ";
    } elseif ( $ViewModeId == 2 ) {
        $where = "`dateadd` > '0000-00-00' AND `newurl` != '' ";
    } elseif ( $ViewModeId == 0 ) {
        $where = "`dateadd` = '0000-00-00' ";
    } else {
        $where = "`newurl` != ''";
    }

    // Filter URLs
    if ($ComponentFilter != '' && $ViewModeId != 1)
        $where .= "AND `newurl` LIKE '%option=$ComponentFilter%' ";
    if ($FilterSEF != '')
        $where .= "AND `oldurl` LIKE '%$FilterSEF%' ";
    if ($FilterReal != '' && $ViewModeId != 1)
        $where .= "AND `newurl` LIKE '%$FilterReal%' ";

    // make the select list for the filter
    $viewmode[] = mosHTML::makeOption('3', _COM_SEF_SHOW3);
    $viewmode[] = mosHTML::makeOption('2', _COM_SEF_SHOW2);
    $viewmode[] = mosHTML::makeOption('0', _COM_SEF_SHOW0);
    $viewmode[] = mosHTML::makeOption('1', _COM_SEF_SHOW1);
    $lists['viewmode'] = mosHTML::selectList($viewmode, 'viewmode', "class=\"inputbox\" onchange=\"document.adminForm.submit();\" size=\"1\"" ,  'value', 'text', $ViewModeId);

    // make the select list for the filter
    $orderby[] = mosHTML::makeOption('0', _COM_SEF_SEFURL._COM_SEF_ASC);
    $orderby[] = mosHTML::makeOption('1', _COM_SEF_SEFURL._COM_SEF_DESC);
    if ($ViewModeId != 1) {
        $orderby[] = mosHTML::makeOption('2', _COM_SEF_REALURL._COM_SEF_ASC);
        $orderby[] = mosHTML::makeOption('3', _COM_SEF_REALURL._COM_SEF_DESC);
    }
    $orderby[] = mosHTML::makeOption('4', _COM_SEF_HITS._COM_SEF_ASC);
    $orderby[] = mosHTML::makeOption('5', _COM_SEF_HITS._COM_SEF_DESC);
    $lists['sortby'] = mosHTML::selectList($orderby, 'sortby', "class=\"inputbox\" onchange=\"document.adminForm.submit();\" size=\"1\"" , 'value', 'text', $SortById);

    // make the select list for the component filter
    $comList[] = mosHTML::makeOption('', _COM_SEF_FILTERCOMPONENTALL);
    $comList[] = mosHTML::makeOption('com_content', 'Content');
    $database->setQuery("SELECT `name`,`option` FROM #__components WHERE parent = 0 ORDER BY `name`");
    $rows = $database->loadObjectList();
    if ($database->getErrorNum()) {
        echo $database->stderr();
        return false;
    }
    foreach(array_keys($rows) as $i) {
        $row = &$rows[$i];
        $comList[] = mosHTML::makeOption( $row->option, $row->name );
    }
    $lists['comList'] = mosHTML::selectList( $comList, 'comFilter', "class=\"inputbox\" onchange=\"document.adminForm.submit();\" size=\"1\"", 'value', 'text', $ComponentFilter);

    // make the filter text boxes
    $lists['filterSEF']  = "<input type=\"text\" name=\"filterSEF\" value=\"$FilterSEF\" size=\"40\" maxlength=\"255\" onchange=\"document.adminForm.submit();\" title=\""._COM_SEF_FILTERSEF_HLP."\" />";
    $lists['filterReal'] = "<input type=\"text\" name=\"filterReal\" value=\"$FilterReal\" size=\"40\" maxlength=\"255\" onchange=\"document.adminForm.submit();\" title=\""._COM_SEF_FILTERREAL_HLP."\" />";

    switch ($SortById) {
        case 1: $sort = "`oldurl` DESC"; break;
        case 2: $sort = "`newurl`"; break;
        case 3: $sort = "`newurl` DESC"; break;
        case 4: $sort = "`cpt`"; break;
        case 5: $sort = "`cpt` DESC"; break;
        default: $sort = "`oldurl`"; break;
    }
    // get the total number of records
    $query = "SELECT count(*) FROM #__redirection WHERE ".$where;

    $database->setQuery($query);
    $total = $database->loadResult();

    require_once($GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php');
    $pageNav = new mosPageNav( $total, $limitstart, $limit );

    // get the subset (based on limits) of required records
    $query = "SELECT * FROM #__redirection WHERE ".$where." ORDER BY ".$sort." LIMIT $pageNav->limitstart,$pageNav->limit";
    $database->setQuery($query);
    $rows = $database->loadObjectList();
    if ($database->getErrorNum()) {
        echo $database->stderr();
        return false;
    }

    HTML_sef::viewSEF($rows, $lists, $pageNav, $option, $ViewModeId);
}

/**
 * Creates a new or edits and existing user record.
 *
 * @param int The id of the user, 0 if a new entry
 * @param string The current GET/POST option
 */
function editSEF($id, $option)
{
    global $database, $my, $mainframe;

    $LinkTypeId = $mainframe->getUserStateFromRequest("linktype{$option}",   'linktype',   0);
    $SectionId  = $mainframe->getUserStateFromRequest("sectionid{$option}",  'sectionid',  0);
    $CategoryId = $mainframe->getUserStateFromRequest("categoryid{$option}", 'categoryid', 0);
    $ContentId  = $mainframe->getUserStateFromRequest("contentid{$option}",  'contentid',  0);

    $row = new mosSEF( $database );
    // load the row from the db table
    $row->load( $id );

    if ($id) {
        // do stuff for existing records
        if ($row->dateadd != '0000-00-00') $row->dateadd = date('Y-m-d');
    }
    else {
        // do stuff for new records
        $row->dateadd = date("Y-m-d");
    }
    $linktype[] = mosHTML::makeOption( '0', 'Content' );
    $linktype[] = mosHTML::makeOption( '1', 'Component' );
    $lists['linktype'] = mosHTML::selectList( $linktype, 'linktype', "class=\"inputbox\"  onchange=\"document.buildLinkForm.submit();\" size=\"1\"" , 'value', 'text', $LinkTypeId );
    $lists['linktype'] = mosHTML::selectList( $linktype, 'linktype', "class=\"inputbox\"  onchange=\"document.buildLinkForm.submit();\" size=\"1\"" , 'value', 'text', $LinkTypeId );

    switch ($LinkTypeId) {
        case 0: {
            // content

            // build section list
            $database->setQuery( "SELECT `id`,`title` FROM #__sections");
            $sections = $database->loadObjectList();
            $options = array(  mosHTML::makeOption( 0, "(static content)"));
            foreach($sections as $section) {

                $options[] = mosHTML::makeOption( $section->id, $section->title );
            }
            $lists['sections'] = mosHTML::selectList($options, 'sectionid', 'class="inputbox" onchange="document.buildLinkForm.submit();" size="1"', 'value', 'text', $SectionId);

            // build category list
            if ($SectionId) {
                $database->setQuery( "SELECT `id`,`title` FROM #__categories WHERE `section`='".$SectionId."'");
                $cats = $database->loadObjectList();
                $options = array(  mosHTML::makeOption( 0, "(NONE)")  );
                $options[] =  mosHTML::makeOption( -1, "(section)");
                $options[] =  mosHTML::makeOption( -2, "(blog section)");
                foreach($cats as $cat) {
                    $options[] = mosHTML::makeOption( $cat->id, $cat->title );
                }
                $lists['cats'] = mosHTML::selectList($options, 'categoryid', 'class="inputbox" onchange="document.buildLinkForm.submit();" size="1"', 'value', 'text', $CategoryId);
            }
            else $CategoryId = 0;

            $sql = "SELECT `id`,`title` FROM #__content WHERE ((`sectionid`='".$SectionId."') AND (`catid`='".$CategoryId."'))";
            $database->setQuery($sql);
            $items = $database->loadObjectList();
            $options = array(mosHTML::makeOption( 0, '(NONE)'));
            if ($SectionId) {
                $options[] = mosHTML::makeOption( "-1", "(category)");
                $options[] = mosHTML::makeOption( "-2", "(blog category)");
            }

            foreach($items as $item) {
                $options[] = mosHTML::makeOption( $item->id, $item->title );
            }
            $lists['content'] = mosHTML::selectList( $options, 'contentid', 'class="inputbox" onchange="document.buildLinkForm.submit();" size="1"', 'value', 'text', $ContentId );
            $database->setQuery( $sql );
            // needed to reduce queries used by getItemid
            $bs = $mainframe->getBlogSectionCount();
            $bc = $mainframe->getBlogCategoryCount();
            $gbs = $mainframe->getGlobalBlogSectionCount();
            $Itemid = $mainframe->getItemid( $ContentId, ($SectionId == 0), 0, $bs, $bc, $gbs );
            $this_link = "index.php?option=com_content&task=";
            $lists['msg'] = '';

            switch ($CategoryId) {
                case -2: {
                    $this_link .= "blogsection&id=$SectionId";
                    break;
                }
                case -1: {
                    $this_link .= "section&id=$SectionId";
                    $database->setQuery("SELECT `id` FROM #__menu WHERE (`link` like '%".$this_link."%')");
                    $result = $database->loadResult();
                    if (is_numeric($result)){
                        $this_link .= "&Itemid=$result";
                    } else {
                        $this_link .= "&Itemid=$Itemid";
                        $lists['msg'] = _COM_SEF_INVALID_URL;
                    }
                    break;
                }
                default: {
                    switch ($ContentId) {
                        case -2: {
                            $this_link .= "blogsection&id=$SectionId";
                            break;
                        }
                        case -1: {
                            $database->setQuery("SELECT `id` FROM #__menu WHERE (`link` like '%".$this_link."section&id=$SectionId%')");
                            $result = $database->loadResult();
                            $this_link .= "category&sectionid=$SectionId&id=$CategoryId";
                            if (is_numeric($result)) {
                                $this_link .= "&Itemid=$result";
                            }
                            else {
                                $this_link .= "&Itemid=$Itemid";
                                $lists['msg'] = _COM_SEF_INVALID_URL;
                            }
                            break;
                        }
                        default: {
                            $this_link = "index.php?option=com_content&task=view&id=$ContentId&Itemid=$Itemid";
                        }
                    }
                }
                $lists['this_link'] = $this_link;
            }
            break;
        }
        case 1: // component
        break;
    }
    HTML_sef::editSEF($row, $lists, $option);
}

/**
* Saves the record from an edit form submit.
*
* @param string The current GET/POST option
*/
function saveSEF($option)
{
    global $database, $my;

    $row = new mosSEF($database);
    if (!$row->bind($_POST)) {
        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
        exit();
    }

    // pre-save checks
    if (!$row->check()) {
        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
        exit();
    }

    // save the changes
    if (!$row->store()) {
        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
        exit();
    }

    mosRedirect('index2.php?option='.$option.'&task=view');
}

/**
* Removes records
* @param array An array of id keys to remove
* @param string The current GET/POST option
*/
function removeSEF(&$cid, $option)
{
    global $database;

    if (!is_array($cid) || count( $cid ) < 1) {
        echo "<script> alert('"._COM_SEF_SELECT_DELETE."'); window.history.go(-1);</script>\n";
        exit;
    }

    if (count($cid)) {
        $cids = implode(',', $cid);
        $query = "DELETE FROM #__redirection"
        . "\n WHERE id IN ($cids)"
        ;
        $database->setQuery($query);
        if (!$database->query()) {
            echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
        }
    }
    mosRedirect( 'index2.php?option='.$option.'&task=view' );
}

/**
* Cancels an edit operation
* @param string The current GET/POST option
*/
function cancelSEF( $option )
{
    global $database;

    if ($_POST['section'] == "config") {
        mosRedirect('index2.php?option='.$option);
    }
    else {
        mosRedirect('index2.php?option='.$option.'&task=view');
    }
}

function showConfig($option)
{
    global $sefConfig, $sef_config_file;
    global $database;

    $std_opt = 'class="inputbox" size="2"';

    $lists['enabled']     = mosHTML::yesnoRadioList('enabled',     $std_opt, $sefConfig->enabled);
    $lists['lowerCase']   = mosHTML::yesnoRadioList('lowerCase',   $std_opt, $sefConfig->lowerCase);
    $lists['showSection'] = mosHTML::yesnoRadioList('showSection', $std_opt, $sefConfig->showSection);
    $lists['showCat']     = mosHTML::yesnoRadioList('showCat',     $std_opt, $sefConfig->showCat);

    // lang placement
    $langPlacement[] = mosHTML::makeOption(_COM_SEF_LANG_PATH,   _COM_SEF_LANG_PATH_TXT);
    $langPlacement[] = mosHTML::makeOption(_COM_SEF_LANG_SUFFIX, _COM_SEF_LANG_SUFFIX_TXT);
    $langPlacement[] = mosHTML::makeOption(_COM_SEF_LANG_NONE,   _COM_SEF_LANG_NONE_TXT);
    $lists['langPlacement'] = mosHTML::radioList($langPlacement, 'langPlacement', $std_opt, $sefConfig->langPlacement);
    //$lists['langToPath']    = mosHTML::yesnoRadioList('langToPath',  $std_opt, $sefConfig->langToPath);
    
    $lists['alwaysUseLang']  = mosHTML::yesnoRadioList('alwaysUseLang',  $std_opt, $sefConfig->alwaysUseLang);
    $lists['translateNames'] = mosHTML::yesnoRadioList('translateNames', $std_opt, $sefConfig->translateNames);
    $lists['excludeSource']  = mosHTML::yesnoRadioList('excludeSource',  $std_opt, $sefConfig->excludeSource);
    $lists['reappendSource'] = mosHTML::yesnoRadioList('reappendSource', $std_opt, $sefConfig->reappendSource);
    $lists['appendNonSef']   = mosHTML::yesnoRadioList('appendNonSef', $std_opt, $sefConfig->appendNonSef);
    //$lists['useAlias']       = mosHTML::yesnoRadioList('useAlias', $std_opt, $sefConfig->useAlias);

    if ($sefConfig->useAlias == 0) {
        $fulltitle = 'checked="checked"';
        $titlealias = '';
    }
    else {
        $titlealias = 'checked="checked"';
        $fulltitle = '';
    }
    $lists['useAlias'] =  '
		<input type="radio" name="useAlias" value="0" class="inputbox"'.$fulltitle.'size="2" />'._COM_SEF_FULL_TITLE.'
		<input type="radio" name="useAlias" value="1" class="inputbox"'.$titlealias.'size="2" />'._COM_SEF_TITLE_ALIAS.'
	';

    // get a list of the static content items for 404 page
    $query = "SELECT id, title"
    ."\n FROM #__content"
    ."\n WHERE sectionid = 0 AND title != '404'"
    ."\n AND catid = 0"
    ."\n ORDER BY ordering"
    ;

    $database->setQuery( $query );
    $items = $database->loadObjectList();

    $options = array(mosHTML::makeOption(0, '('._COM_SEF_DEF_404_PAGE.')'));
    $options[] = mosHTML::makeOption(9999999, '(Front Page)');

    // assemble menu items to the array
    foreach ( $items as $item ) {
        $options[] = mosHTML::makeOption($item->id, $item->title);
    }

    $lists['page404'] = mosHTML::selectList( $options, 'page404', 'class="inputbox" size="1"', 'value', 'text', $sefConfig->page404 );
    $sql='SELECT id,introtext FROM #__content WHERE `title`="404"';
    $row = null;
    $database->setQuery($sql);
    $database->loadObject($row);

    $txt404 = isset($row->introtext) ? $row->introtext : _COM_SEF_DEF_404_MSG;

    // get list of installed components for advanced config
    $installed_components = $undefined_components = array();
    $sql = 'SELECT SUBSTRING(link,8) AS name FROM #__components WHERE CHAR_LENGTH(link) > 0 ORDER BY name';
    $database->setQuery($sql);
    $installed_components = $database->loadResultArray();
    $undefined_components= array_values(array_diff($installed_components,array_intersect($sefConfig->predefined, $installed_components)));

    // build mode list and create the list
    $mode = array();
    $mode[] = mosHTML::makeOption(0, _COM_SEF_USE_DEFAULT);
    $mode[] = mosHTML::makeOption(1, _COM_SEF_NOCACHE);
    $mode[] = mosHTML::makeOption(2, _COM_SEF_SKIP);

    while (list($index, $name) = each($undefined_components)) {
        $selectedmode = ((in_array($name, $sefConfig->nocache)) * 1) + ((in_array($name, $sefConfig->skip)) * 2);
        $lists['adv_config'][$name] = mosHTML::selectList( $mode, $name, 'class="inputbox" size="1"', 'value', 'text', $selectedmode);
    }

    HTML_sef::configuration($lists, $txt404);
}

function advancedConfig($key,$value)
{
    global $sefConfig;

    $debug = 0;

    if ((strpos($key, 'com_')) !== false) {
        if ($debug) echo "<p class='error'>FOUND COMPONENT:$key</p>";
        switch ($value) {
            case 1: {
                array_push($sefConfig->nocache, $key);
                break;
            }
            case 2: {
                array_push($sefConfig->skip, $key);
                break;
            }
        }
    }
    if ($debug) echo "<br>KEY=$key:VALUE=$value:";

}

function saveConfig()
{
    global $database, $sefConfig, $sef_config_file;

    $debug = 0;

    //set skip and nocache arrays
    $sefConfig->skip = array();
    $sefConfig->nocache = array();
    foreach($_POST as $key => $value) {
        $sefConfig->set($key, $value);
        advancedConfig($key, $value);
    }

    $sql = 'SELECT id  FROM #__content WHERE `title` = "404"';
    $database->setQuery( $sql );

    if ($id = $database->loadResult()){
        $sql = 'UPDATE #__content SET introtext="'.addslashes($_POST['introtext']).'",  modified ="'.date("Y-m-d H:i:s").'" WHERE `id` = "'.$id.'";';
    }
    else {
        $sql='SELECT MAX(id)  FROM #__content';
        $database->setQuery($sql);
        if ($max = $database->loadResult()) {
            $max++;
            $sql = 'INSERT INTO #__content VALUES( "'.$max.'", "404", "404", "'.addslashes($_POST['introtext']).'", "", "1", "0", "0", "0", "2004-11-11 12:44:38", "62", "", "'.date("Y-m-d H:i:s").'", "0", "62", "2004-11-11 12:45:09", "2004-10-17 00:00:00", "0000-00-00 00:00:00", "", "", "menu_image=-1\nitem_title=0\npageclass_sfx=\nback_button=\nrating=0\nauthor=0\ncreatedate=0\nmodifydate=0\npdf=0\nprint=0\nemail=0", "1", "0", "0", "", "", "0", "750");';
        }
    }

    $database->setQuery( $sql );
    if (!$database->query()) {
        echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }

    if (is_writable($sef_config_file)) {
        $purge = isset($_POST['purge']) ? $_POST['purge'] : "0";

        $config_written = $sefConfig->saveConfig(0, $purge);
        //die("config_written:$config_written");
        if($config_written != 0) {
            if ($debug) {
                echo"<div align='left'><pre>CONFIG:";
                print_r($sefConfig);
                echo "<br />POST:";
                print_r($_POST);
                die("</pre></div>");
            }
            mosRedirect('index2.php?option=com_sef', _COM_SEF_CONFIG_UPDATED );
        } else mosRedirect('index2.php?option=com_sef&task=dwnld', _COM_SEF_WRITE_ERROR);
    } else mosRedirect('index2.php?option=com_sef&task=dwnld', _COM_SEF_WRITE_ERROR);
}

function purge($option, $ViewModeId = 0)
{
    global $database, $mainframe;

    $ViewModeId = $mainframe->getUserStateFromRequest( "viewmode{$option}", 'viewmode', 0 );
    $SortById = $mainframe->getUserStateFromRequest( "SortBy{$option}", 'sortby', 0 );
    $confirmed = mosGetParam( $_REQUEST, 'confirmed', 0 );

    switch ($ViewModeId) {
        case '1': {
            $where = "`dateadd` > '0000-00-00' and `newurl` = '' ";
            break;
        }
        case '2': {
            $where = "`dateadd` > '0000-00-00' and `newurl` != '' ";
            break;
        }
        default: {
            $where = "`dateadd` = '0000-00-00'";
            break;
        }
    }

    if ( $confirmed == "Proceed") {
        $query = "DELETE FROM #__redirection WHERE ".$where;
        $database->setQuery( $query );
        if (!$database->query()) {
            echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
        }
        else $message = _COM_SEF_SUCCESSPURGE;
    }
    else {
        // get the total number of records
        $query = "SELECT count(*) FROM #__redirection WHERE ".$where;
        $database->setQuery( $query );
        $total = $database->loadResult();
        if (!$database->query()) {
            echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
        }
        switch ($total) {
            case '0'; {
                $message = _COM_SEF_NORECORDS;
                break;
            }
            case '1'; {
                $message = _COM_SEF_WARNDELETE.$total._COM_SEF_RECORD;
                break;
            }
            default: {
                $message = _COM_SEF_WARNDELETE.$total._COM_SEF_RECORDS;
            }
        }
    }
    HTML_sef::purge($option, $message, $confirmed);
}

function backup_custom()
{
    global $database;

    $SQL = array();

    $table = $GLOBALS['mosConfig_dbprefix']."redirection";
    $query ="SELECT * FROM `$table` WHERE (`dateadd` > '0000-00-00' and `newurl` != '' )";
    $database->setQuery( $query );
    if ($rows = $database->loadRowList()) {
        foreach ($rows as $row) {
            $fields = "''";
            for ($i = 1; $i < 11; $i++) {
                $fields .= ",'".$row[$i]."'";
            }
            $SQL[] = "INSERT INTO `$table` (id, cpt, oldurl, newurl, metadesc, metakey, metatitle, metalang, metarobots, metagoogle, dateadd) VALUES(".$fields.");\n";
        }
    }
    else die(_COM_SEF_NOACCESS.$table);
    return $SQL;
}

function output_attachment($filename,&$data)
{
    if (!headers_sent()) {
        header ('Expires: 0');
        header ('Last-Modified: '.gmdate ('D, d M Y H:i:s', time()) . ' GMT');
        header ('Pragma: public');
        header ('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header ('Accept-Ranges: bytes');
        header ('Content-Length: ' . strlen($data));
        header ('Content-Type: Application/octet-stream');
        header ('Content-Disposition: attachment; filename="' . $filename . '"');
        header ('Connection: close');
        ob_end_clean(); //flush the mambo stuff from the ouput buffer
        print $data; // and send the sql
        die();
    }
    else die(_COM_SEF_FATAL_ERROR_HEADERS);
}

function export_custom($filename)
{
    global $database;

    $sql_data = backup_custom();
    $sql_data = implode("\r\n", $sql_data);
    if (!headers_sent()) {
        while (ob_get_level() > 0) {
            ob_end_clean(); //flush the mambo stuff from the ouput buffer
        }

        // Determine Browser
        if (ereg( 'MSIE ([0-9].[0-9]{1,2})', $_SERVER["HTTP_USER_AGENT"], $log_version)) {
            $BROWSER_VER=$log_version[1];
            $BROWSER_AGENT='IE';
        } elseif (ereg( 'Opera ([0-9].[0-9]{1,2})', $_SERVER["HTTP_USER_AGENT"], $log_version)) {
            $BROWSER_VER=$log_version[1];
            $BROWSER_AGENT='OPERA';
        } elseif (ereg( 'Mozilla/([0-9].[0-9]{1,2})', $_SERVER["HTTP_USER_AGENT"], $log_version)) {
            $BROWSER_VER=$log_version[1];
            $BROWSER_AGENT='MOZILLA';
        } else {
            $BROWSER_VER=0;
            $BROWSER_AGENT='OTHER';
        }
        ob_start();
        header ('Expires: 0');
        header ('Last-Modified: '.gmdate ('D, d M Y H:i:s', time()) . ' GMT');
        header ('Pragma: public');
        header ('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header ('Accept-Ranges: bytes');
        header ('Content-Length: ' . strlen($sql_data));
        header ('Content-Type: Application/octet-stream');
        header ('Content-Disposition: attachment; filename="' . $filename . '"');
        header ('Connection: close');

        echo($sql_data);

        ob_end_flush();
        die();
    }
    else{
        echo "Error! Not Good!";
        die(""._COM_SEF_FATAL_ERROR_HEADERS);
    }
}



function import_custom($userfile)
{
    global $database;

    $uploaddir  = $GLOBALS['mosConfig_absolute_path'].'/media/';
    $uploadfile = $uploaddir.basename($userfile['name']);

    if (move_uploaded_file($userfile['tmp_name'], $uploadfile)) {
        echo '<p class="message">'._COM_SEF_UPLOAD_OK.'</p>';
        $result = true;
        $lines = file($uploadfile);

        $command = "INSERT INTO `".$GLOBALS['mosConfig_dbprefix']."redirection`";
        for ($i = 0; $i < count($lines); $i++) {
            // Trim line
            $line = trim($lines[$i]);
            // Ignore empty lines
            if (strlen($line) == 0) continue;

            // If the query continues at the next line.
            while (substr($line, -1) != ';' && $i + 1 < count($lines)) {
                $i++;
                $newLine = trim($lines[$i]);
                if (strlen($newLine) == 0) continue;
                $line .= ' '.$lines[$i];
            }

            if (preg_match('/^INSERT INTO `?(\w)+redirection`?/', $line) > 0) {
                // Fix for files exported from versions older than 1.3.0
                if (strstr($line, "redirection` VALUES") != false) {
                    $line = str_replace("redirection` VALUES", "redirection` (id, cpt, oldurl, newurl, dateadd) VALUES", $line);
                }
                $database->setQuery($line);
                if (!$database->query()) {
                    echo("<p class='error'>"._COM_SEF_ERROR_IMPORT."<pre>$line</pre></p>");
                    $result = false;
                    echo ($database->getErrorMsg());
                }
            }
            else echo("<p class='error'>"._COM_SEF_IGNORE_SQL.substr($line, 0, 40)."</p>");
        }

        unlink($uploadfile) OR die("<p class='error'>"._COM_SEF_NO_UNLINK."</p>");
        if ($result) echo('<p class="message">'._COM_SEF_IMPORT_OK.'</p>');
		?>
		<form><input type="button" value="<?php echo _COM_SEF_PROCEED; ?>" onClick="javascript:location.href='index2.php?option=com_sef&task=view&viewmode=2'"></form>
		<?php
    }
    else {
        echo "<p class='error'>"._COM_SEF_WRITE_FAILED."</p>";
        $result = false;
    }

    return $result;
}

// Recursively deletes directory and all of its contents
/*function deldir( $dir ) {
    $current_dir = opendir( $dir );
    $old_umask = umask(0);
    while ($entryname = readdir( $current_dir )) {
        if ($entryname != '.' and $entryname != '..') {
            if (is_dir( $dir . $entryname )) {
                deldir( mosPathName( $dir . $entryname ) );
            } else {
                @chmod($dir . $entryname, 0777);
                unlink( $dir . $entryname );
            }
        }
    }
    umask($old_umask);
    closedir( $current_dir );
    return rmdir( $dir );
}*/

function showNavigationBar($moduleName = '')
{
  ?>
    <div style="text-align: left;">
    <strong><a href="index2.php?option=com_sef">JoomSEF</a><?php $moduleName != '' ? print(" / $moduleName") : ''; ?></strong>
    </div>
  <?php
}
?>
