<?php

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

class JRouterArtio extends JRouter
{
	/**
	 * Class constructor
	 *
	 * @access public
	 */
	function __construct($options = array()) {
		//parent::__construct($options);
	}
	
	function &_createURI($url) {
        // Create full URL if we are only appending variables to it
        if(substr($url, 0, 1) == '&')
        {
            $vars = array();
            parse_str($url, $vars);

            $vars = array_merge($this->getVars(), $vars);

            foreach($vars as $key => $var)
            {
                if($var == "") {
                    unset($vars[$key]);
                }
            }

            $url = 'index.php?'.JURI::buildQuery($vars);
        }

        // Decompose link into url component parts
        $uri = new JURI($url);

        return $uri;
	}

    function &build($url) {
        $uri = $this->_createURI($url);
        
		// Set URI defaults
		$menu =& JSite::getMenu();

		// Get the itemid from the URI
		$itemid = $uri->getVar('Itemid');

		if(is_null($itemid))
		{
			if($option = $uri->getVar('option'))
			{
				$item  = $menu->getItem($this->getVar('Itemid'));
				if(isset($item) && $item->component == $option) {
					$uri->setVar('Itemid', $item->id);
				}
			}
			else
			{
				if($option = $this->getVar('option')) {
					$uri->setVar('option', $option);
				}

				if($itemid = $this->getVar('Itemid')) {
					$uri->setVar('Itemid', $itemid);
				}
			}
		}
/*		else
		{
			if(!$uri->getVar('option'))
			{
				$item  = $menu->getItem($itemid);
				$uri->setVar('option', $item->component);
			}
		}
*/
		$url = $uri->toString();
        $newUrl = legacySefRelToAbs($url);
        $uri = new JURI($newUrl);
        
        return $uri;
    }
    
    function parse(&$uri) {
        global $vars;
		$vars   = array();

        include('sef.php');

        //return $vars;
        
		$menu =& JSite::getMenu(true);

		//Handle an empty URL (special case)
		if(empty($vars['Itemid']) && empty($vars['option']))
		{
			$item = $menu->getDefault();
			if(!is_object($item)) return $vars; // No default item set

			//Set the information in the request
			$vars = $item->query;

			//Get the itemid
			$vars['Itemid'] = $item->id;

			// Set the active menu item
			$menu->setActive($vars['Itemid']);

			return $vars;
		}

		//Get the variables from the uri
		$this->setVars($vars);

		//Get the itemid, if it hasn't been set force it to null
		$this->setVar('Itemid', JRequest::getInt('Itemid', null));

		//Only an Itemid ? Get the full information from the itemid
		if(!isset($vars['option']))
		{
			$item = $menu->getItem($this->getVar('Itemid'));
			$vars = $vars + $item->query;
		}

		// Set the active menu item
		$menu->setActive($this->getVar('Itemid'));

		return $vars;
    }
}

?>