<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 * @license     Released under the terms of the GNU General Public License
 */

// Security check to ensure this file is being included by a parent file.
defined( '_JEXEC' ) or die( 'Restricted access' );

class plgSystemJoomsef_MetaBot extends JPlugin
{
    function plgSystemJoomsef_MetaBot( &$subject ) {
        parent::__construct($subject);

        // load plugin parameters
        $this->_plugin = & JPluginHelper::getPlugin( 'system', 'joomsef_metabot' );
        $this->_params = new JParameter( $this->_plugin->params );
    }

    function onAfterDispatch() {
        global $mainframe;
        
        // Do not run plugin in administration area
        if( JPATH_BASE == JPATH_ADMINISTRATOR ) {
            return true;
        }
        
        $document = & JFactory::getDocument();

        $this->_checkSefTitle();
        $this->_generateMeta();

        return true;
    }

    function _generateMeta() {
        global $mainframe;

        $document = & JFactory::getDocument();
        
        $rewriteKeywords    = $this->_params->get('rewrite_keywords');
        $rewriteDescription = $this->_params->get('rewrite_description');

        $metadesc   = $mainframe->get('sef.meta.desc');
        $metakey    = $mainframe->get('sef.meta.key');
        $metalang   = $mainframe->get('sef.meta.lang');
        $metarobots = $mainframe->get('sef.meta.robots');
        $metagoogle = $mainframe->get('sef.meta.google');

        // Description metatag
        if( !empty($metadesc) ) {
            $oldDesc = $document->getDescription();
            $rewrite = (($rewriteDescription == '1') || ($oldDesc == ''));
            
            if( $rewrite ) {
                $document->setDescription($metadesc);
            } else {
                $document->setDescription($metadesc . ', ' . $oldDesc);
            }
        }

        // Keywords metatag
        if( !empty($metakey) ) {
            $oldKey = $document->getMetaData('keywords');
            $rewrite = (($rewriteKeywords == '1') || ($oldKey == ''));
            
            if( $rewrite ) {
                $document->setMetaData('keywords', $metakey);
            } else {
                $document->setMetaData('keywords', $metakey . ', ' . $oldKey);
            }
        }
        
        if( !empty($metalang) )     $document->setMetaData('lang', $metalang);
        if( !empty($metarobots) )   $document->setMetaData('robots', $metarobots);
        if( !empty($metagoogle) )   $document->setMetaData('google', $metagoogle);
    }

    function _checkSefTitle() {
        global $mainframe;

        $document = & JFactory::getDocument();
        $config = & JFactory::getConfig();

        $sitename = $config->getValue('sitename');
        $preferTitle = $this->_params->get('prefer_joomsef_title');
        $useSitename = $this->_params->get('use_sitename');
        $sitenameSep = ' '.$this->_params->get('sitename_sep').' ';
        $preventDupl = $this->_params->get('prevent_dupl');

        if( $sitenameSep == '  ' ) {
            $sitenameSep = ' ';
        }
        
        // Page title
        $pageTitle = $mainframe->get('sef.meta.title');
        if( empty($pageTitle) ) {
            $pageTitle = $document->getTitle();

            // Dave: replaced regular expression as it was causing problems
            //       with site names like [ index-i.cz ] with str_replace
            /*$pageSep = '( - |'.$sitenameSep.')';
            if (preg_match('/('.$GLOBALS['mosConfig_sitename'].$pageSep.')?(.*)?/', $pageTitle, $matches) > 0) {
            $pageTitle = strtr($pageTitle, array($matches[1] => ''));
            }*/
            $pageTitle = str_replace(array($sitename.' - ', $sitename.$sitenameSep), array('', ''), $pageTitle);
        }

        if( $preferTitle ) {
            $pageTitle = trim($pageTitle);

            // Prevent name duplicity if set to
            if ($preventDupl && strcmp($pageTitle, trim($sitename)) == 0) {
                $pageTitle = '';
            }

            if (empty($pageTitle)) $sitenameSep = '';
            
            if ($useSitename == 1 && $sitename) {
                $pageTitle = $sitename.$sitenameSep.$pageTitle;
            }
            elseif ($useSitename == 2 && $sitename) {
                $pageTitle .= $sitenameSep.$sitename;
            }

            // set page title
            if ($pageTitle) {
                $document->setTitle($pageTitle);
                $document->setMetaData('title', $pageTitle);
            }
        }
    }
}

?>
