<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.4.2
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

jimport('joomla.application.helper');

require_once JPATH_ADMINISTRATOR.'/components/com_sef/classes/config.php';

$db=JFactory::getDBO();

/*// XML definition file
$this->_addFileOp('/administrator/components/com_sef/sef.xml', 'upgrade', '/sef.xml');
$this->_addFileOp('/administrator/components/com_sef/classes/seftools.php', 'upgrade', '/admin/classes/seftools.php');
$this->_addFileOp('/administrator/components/com_sef/views/info/tmpl/changelog.inc.html', 'upgrade', '/admin/views/info/tmpl/changelog.inc.html');
$this->_addFileOp('/administrator/components/com_sef/views/info/tmpl/readme.inc.html', 'upgrade', '/admin/views/info/tmpl/readme.inc.html');

// Admin files
$this->_addFileOp('/administrator/components/com_sef/controller.php', 'upgrade', '/admin/controller.php');
$this->_addFileOp('/administrator/components/com_sef/controllers/extension.php', 'upgrade', '/admin/controllers/extension.php');
$this->_addFileOp('/administrator/components/com_sef/models/extension.php', 'upgrade', '/admin/models/extension.php');
$this->_addFileOp('/administrator/components/com_sef/models/extensions.php', 'upgrade', '/admin/models/extensions.php');
$this->_addFileOp('/administrator/components/com_sef/models/upgrade.php', 'upgrade', '/admin/models/upgrade.php');
$this->_addFileOp('/administrator/components/com_sef/views/extension/tmpl/default.php', 'upgrade', '/admin/views/extension/tmpl/default.php');
$this->_addFileOp('/administrator/components/com_sef/views/extension/tmpl/editid.php', 'upgrade', '/admin/views/extension/tmpl/editid.php');
$this->_addFileOp('/administrator/components/com_sef/views/extensions/view.html.php', 'upgrade', '/admin/views/extensions/view.html.php');
$this->_addFileOp('/administrator/components/com_sef/views/extensions/tmpl/default.php', 'upgrade', '/admin/views/extensions/tmpl/default.php');
$this->_addFileOp('/administrator/components/com_sef/views/templates/default_extslist.php', 'upgrade', '/admin/views/templates/default_extslist.php');

// Frontend files
$this->_addFileOp('/components/com_sef/joomsef.php', 'upgrade', '/site/joomsef.php');

// Language files
// We need to check every directory for existence and copy only the languages in use
if( JFolder::exists(JPATH_ROOT.'/administrator/language/en-GB') ) {
    $this->_addFileOp('/administrator/language/en-GB/en-GB.com_sef.ini', 'upgrade', '/admin/language/en-GB/en-GB.com_sef.ini');
}

if( JFolder::exists(JPATH_ROOT.'/administrator/language/cs-CZ') ) {
    $this->_addFileOp('/administrator/language/cs-CZ/cs-CZ.com_sef.ini', 'upgrade', '/admin/language/cs-CZ/cs-CZ.com_sef.ini');
}*/

require_once(dirname(__FILE__).'/reinstall.php');


// Adapters
$this->_addFileOp('/libraries/joomla/installer/adapters/sef_ext.php','upgrade','admin/adapters/sef_ext.php');
$this->_addFileOp('/libraries/joomla/updater/adapters/sef_update.php','upgrade','admin/adapters/sef_update.php');

//New plugins
$this->_addFileOp('/plugins/system/joomseflang/joomseflang.php','upgrade','admin/plugin/joomseflang.php');
$this->_addFileOp('/plugins/system/joomseflang/joomseflang.xml','upgrade','admin/plugin/joomseflang.xml');
$cache=' {"legacy":false,"name":"System Language - ARTIO JoomSEF","type":"plugin","creationDate":"1. August 2011","author":"ARTIO s.r.o.","copyright":"ARTIO s.r.o.","authorEmail":"info@artio.net","authorUrl":"www.artio.net","version":"4.1.0","description":"PLG_JOOMSEFLANG_XML_DESCRIPTION","group":""}';
$db->setQuery("INSERT INTO `#__extensions`
               (name, type, element, folder, client_id, enabled, access, protected, manifest_cache, params, custom_data, system_data, checked_out, checked_out_time, ordering, state)
               VALUES ('System Language - ARTIO JoomSEF', 'plugin', 'joomseflang', 'system', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', '', 0)");
$db->query();
$this->_addFileOp('/plugins/extension/joomsefinstall/joomsefinstall.php','upgrade','admin/plugin/joomsefinstall.php');
$this->_addFileOp('/plugins/extension/joomsefinstall/joomsefinstall.xml','upgrade','admin/plugin/joomsefinstall.xml');
$cache='{"legacy":false,"name":"Extension Install - ARTIO JoomSEF","type":"plugin","creationDate":"1. August 2011","author":"ARTIO s.r.o.","copyright":"ARTIO s.r.o.","authorEmail":"info@artio.net","authorUrl":"www.artio.net","version":"4.1.0","description":"PLG_JOOMSEFLANG_XML_DESCRIPTION","group":""}';
$db->setQuery("INSERT INTO `#__extensions`
			               (name, type, element, folder, client_id, enabled, access, protected, manifest_cache, params, custom_data, system_data, checked_out, checked_out_time, ordering, state)
			               VALUES ('Extension Install - ARTIO JoomSEF', 'plugin', 'joomsefinstall', 'extension', 0, 1, 1, 0, '".$cache."', '{}', '', '', 0, '0000-00-00 00:00:00', '500', 0)");
$db->query();


//Migrate existing extensions to new Joomla Extension tables
JTable::addIncludePath(JPATH_LIBRARIES.'/joomla/database/table');

function getElement($xml) {
	if(isset($xml->files)) {
		if (count($xml->files->children()))	{
			foreach ($xml->files->children() as $file)	{
				if ((string)$file->attributes()->sef_ext) {
					$element = (string)$file->attributes()->sef_ext;
					if(substr($element,0,13)!='ext_joomsef4_') {
						$element='ext_joomsef4_'.$element;
					}
					return $element;
				}
			}
		}
	}
	return '';
}


$query="SELECT * FROM #__sefexts \n";
$db->setQuery($query);
$exts=$this->_db->loadObjectList();

$ext_update_dir=dirname(__FILE__).'/../site/sef_ext/';

for($i=0;$i<count($exts);$i++) {
	$xml_file=JPATH_SITE.'/components/com_sef/sef_ext/'.$exts[$i]->file;
	if(file_exists($ext_update_dir.$exts[$i]->file)) {
		$xml_file=$ext_update_dir.$exts[$i]->file;
	}
	$xml=simplexml_load_file($xml_file);
	$element=getElement($xml);

	$query="SELECT COUNT(*) FROM #__extensions WHERE type=".$db->quote('sef_ext')." AND element=".$db->quote($element);
	$db->setQuery($query);
	$cnt=$db->loadResult();
	if($cnt>0) {
		continue;
	}

	$ext_table=JTable::getInstance('extension');	
	$ext_table->name=(string)$xml->name;
	$ext_table->type='sef_ext';
	$ext_table->element=$element;
	$ext_table->enabled=1;
	$ext_table->protected=0;
	$ext_table->access=1;
	$ext_table->client_id=0;
	$params=new JRegistry($exts[$i]->params);
	$download_id=$params->get('downloadId');
	if(strlen($exts[$i]->title)) {
		$params->def('custom_menu_title',$exts[$i]->title);
	}
	$ext_table->params=$params->toString();
	$ext_table->custom_data=$exts[$i]->filters;
	$ext_table->manifest_cache=json_encode(JApplicationHelper::parseXMLInstallFile($xml_file));
	$ext_table->store();

	$query="INSERT INTO #__schemas SET extension_id=".$ext_table->extension_id.", version_id=".$db->quote((string)$xml->version);
	$db->setQuery($query);
	$db->query();

	if(isset($xml->updateservers->server)) {
		$location=(string)$xml->updateservers->server;
		if(strlen($download_id)) {
			$location=str_replace('.xml','-'.$download_id.'.xml',$location);
		}
		$query="SELECT COUNT(*) FROM #__update_sites \n";
		$query.="WHERE type=".$db->quote($xml->updateservers->server->getAttribute('type'))." AND name=".$db->quote($xml->updateservers->server->getAttribute('name'));
		$db->setQuery($query);
		$cnt=$db->loadResult();
		if($cnt) {
			$query="UPDATE #__update_sites SET location=".$db->quote($location).", enabled=1 \n";
			$query.="WHERE type=".$db->quote($xml->updateservers->server->getAttribute('type'))." AND name=".$db->quote($xml->updateservers->server->getAttribute('name'));
		} else {
			$query="INSERT INTO #__update_sites SET name=".$db->quote($xml->updateservers->server->getAttribute('name')).", type=".$db->quote($xml->updateservers->server->getAttribute('type')).", \n";
			$query.="location=".$db->quote($location).", enabled=1 \n";	
		}
		$db->setQuery($query);
		$db->query();

		$id=$db->insertId();

		$query="SELECT COUNT(*) FROM #__update_sites_extensions \n";
		$query.="WHERE update_site_id=".$id;
		$db->setQuery($query);
		$cnt=$db->loadResult();
		
		if($cnt) {
			$query="UPDATE #__update_sites_extensions \n";
			$query.="SET extension_id=".$ext_table->extension_id." \n";
			$query.="WHERE update_site_id=".$id;
		} else {
			$query="INSERT INTO #__update_sites_extensions SET update_site_id=".$id.", extension_id=".$ext_table->extension_id." \n";	
		}
		$db->setQuery($query);
		$db->query();
	}
}

//Add extensions to Joomla extensions table
$list=JFolder::files(JPATH_SITE.'/components/com_sef/sef_ext');


foreach($list as $sef) {
	if(substr($sef,-4)!='.xml') {
		continue;
	}
	$xml_file=JPATH_SITE.'/components/com_sef/sef_ext/'.$sef;
	if(file_exists($ext_update_dir.$sef)) {
		$xml_file=$ext_update_dir.$sef;
	}
	$xml=simplexml_load_file($xml_file);
	$element=getElement($xml);

	$query="SELECT COUNT(*) FROM #__extensions WHERE type=".$db->quote('sef_ext')." AND element=".$db->quote($element);
	$db->setQuery($query);
	$cnt=$db->loadResult();
	if($cnt>0) {
		continue;
	}
	$ext_table=JTable::getInstance('extension');
	$ext_table->name=(string)$xml->name;
	$ext_table->type='sef_ext';
	$ext_table->element=$element;
	$ext_table->enabled=1;
	$ext_table->protected=0;
	$ext_table->access=1;
	$ext_table->client_id=0;
	if(isset($xml->install->defaultparams)) {
		$ext_table->params=getDefaultParams((string)$xml->install->defaultparams);
	}
	if(isset($xml->install->defaultfilters)) {
		$ext_table->custom_data=getDefaultFilters((string)$xml->install->defaultfilters);
	}
	$ext_table->manifest_cache=json_encode(JApplicationHelper::parseXMLInstallFile($xml_file));
	$ext_table->store();

	$query="INSERT INTO #__schemas SET extension_id=".$ext_table->extension_id.", version_id=".$db->quote((string)$xml->version);
	$db->setQuery($query);
	$db->query();

	if(isset($xml->updateservers->server)) {
		$query="INSERT INTO #__update_sites SET name=".$db->quote($xml->updateservers->server->getAttribute('name')).", type=".$db->quote($xml->updateservers->server->getAttribute('type')).", \n";
		$query.="location=".$db->quote((string)$xml->updateservers->server).", enabled=1 \n";
		$db->setQuery($query);
		$db->query();

		$id=$db->insertId();

		$query="INSERT INTO #__update_sites_extensions SET update_site_id=".$id.", extension_id=".$ext_table->extension_id." \n";
		$db->setQuery($query);
		$db->query();
	}
}

$location="http://www.artio.net/joomla-updates/list/com_joomsef4.xml";
$sefConfig =& SEFConfig::getConfig();
if(strlen($sefConfig->artioDownloadId)) {
	$location=str_replace('.xml','-'.$sefConfig->artioDownloadId.'.xml',$location);
}

$query="INSERT INTO #__update_sites SET name=".$db->quote('com_joomsef').", type=".$db->quote('sef_update').", location=".$db->quote($location).", enabled=1";
$db->setQuery($query);
$db->query();

$update_id=$db->insertId();

$query="SELECT extension_id \n";
$query.="FROM #__extensions \n";
$query .="WHERE element=".$db->quote('com_sef')." \n";
$db->setQUery($query);
$extension_id=$db->loadResult();

$query="INSERT INTO #__update_sites_extensions SET update_site_id=".$update_id.", extension_id=".$extension_id;
$db->setQuery($query);
$db->query();



function getDefaultParams($element) {
    if( !is_a($element, 'JXMLElement') || !count($element->children()) ) {
        return '';
    }

	$defaultParams = $element->children();
	if( count($defaultParams) == 0 ) {
		return '';
	}

	$params = array();
	foreach($defaultParams as $param) {
	    if( $param->name() != 'defaultparam' ) {
	        continue;
	    }

	    $name = $param->attributes()->name;
	    $value = $param->attributes()->value;

	    $params[] = $name . '=' . $value;
	}

	if( count($params) > 0 ) {
	    return implode("\n", $params);
	}
	else {
	    return '';
	}
}

function getDefaultFilters($element) {
    if( !is_a($element, 'JXMLElement') || !count($element->children()) ) {
        return '';
    }

	$defaultFilters = $element->children();
	if( count($defaultFilters) == 0 ) {
		return '';
	}

	$filters = array();
	foreach($defaultFilters as $filter) {
	    if( $filter->name() != 'defaultfilter' ) {
	        continue;
	    }

	    $filters[] = (string)$filter;
	}

	if( count($filters) > 0 ) {
	    return implode("\n", $filters);
	}
	else {
	    return '';
	}
}
?>