<?php
/**
 * User SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_users extends SefExt
{
    function GetUserName($id)
    {
        $user = JUser::getInstance($id);
        
        return $user->username;
    }
    
    function create(&$uri)
    {
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $title = array();
        $title[] = JoomSEF::_getMenuTitleLang(@$option, $lang, @$Itemid);

        if (!empty($view) && ($view != 'login')) {
            $title[] = JText::_('COM_SEF_'.$view);
        }
        
        if (!empty($layout)) {
            $title[] = JText::_('COM_SEF_'.$layout);
        }
        
        if (!empty($task)) {
            $tasks = explode('.', $task);
            
            if ($tasks[0] == 'profile' && isset($user_id)) {
                $title[] = $this->GetUserName($user_id);
            }
            $task = $tasks[1];
        }
        
        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, null, null, @$lang);
        }
        
        return $newUri;
    }

}
?>
