<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFView extends JView
{
    protected function tooltip($tooltip, $title = '', $image = 'tooltip.png')
    {
        $tooltip    = addslashes(htmlspecialchars($tooltip, ENT_COMPAT, 'UTF-8'));
        $title      = addslashes(htmlspecialchars($title, ENT_COMPAT, 'UTF-8'));
        
        $image  = JURI::root(true).'/administrator/components/com_sef/assets/images/'. $image;
        $text   = '<img src="'. $image .'" border="0" alt="'. JText::_('COM_SEF_TOOLTIP') .'"/>';
            
        if ($title) {
            $title .= '::';
        }

        $style = 'style="text-decoration: none; color: #333;"';

        $tip = '<span class="editlinktip hasTip" title="' . $title . $tooltip . '" ' . $style . '>';
        $tip .= $text . '</span>';
        
        return $tip;
    }
    
    protected function renderParams($params, $group)
    {
        $fields = $params->getFieldset($group);
        
        if (count($fields) > 0) {
            echo '<fieldset class="panelform">';
            echo '<ul class="adminformlist">';
            foreach ($fields as $field) {
                echo '<li>';
                echo $field->label;
                echo $field->input;
                echo '</li>';
            }
            echo '</ul>';
            echo '</fieldset>';
        }
    }
}

?>