<?php
/**
 * Weblinks SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

define('_COM_SEF_PRIORITY_WEBLINKS_LINK_ITEMID', 15);
define('_COM_SEF_PRIORITY_WEBLINKS_LINK', 20);
define('_COM_SEF_PRIORITY_WEBLINKS_CATEGORY_ITEMID', 25);
define('_COM_SEF_PRIORITY_WEBLINKS_CATEGORY', 30);

class SefExt_com_weblinks extends SefExt
{

    function getCategoryTitle($id, $getLastOne = false, $title = array())
    {
        if ($this->params->get('show_category') == 0 && ! $getLastOne)
            return $title;
        
        $database = &JFactory::getDBO();
        $database->setQuery('SELECT `id`, ' . (SEFTools::UseAlias($this->params, 'category_alias') ? '`alias` AS `title`' : '`title`') . ', `description`, `parent_id` FROM `#__categories` WHERE `id` = ' . (int) $id . ' AND `extension` = "com_weblinks"');
        
        if (($category = &$database->loadObject())) {
            $this->metadesc = ($category->description = JString::trim($category->description)) ? $category->description : $this->metadesc;
            
            array_unshift($title, ($this->params->get('category_id') == 1 ? $id . '-' . $category->title : $category->title));
            
            if ($this->params->get('show_category') == 2 && (int) $category->parent_id)
                $title = $this->getCategoryTitle($category->parent_id, $getLastOne, $title);
        }
        
        return $title;
    }

    function getWeblinkTitle($id)
    {
        $db = &JFactory::getDBO();
        $db->setQuery('SELECT `id`,`catid`,' . (SEFTools::UseAlias($this->params, 'weblink_alias') ? '`alias` AS `title`' : '`title`') . ' FROM `#__weblinks` WHERE `id` = ' . (int) $id);
        
        if (is_object(($row = &$db->loadObject()))) {
            $title = $this->getCategoryTitle($row->catid);
            $title[] = ($this->params->get('weblink_id') == 1 ? $row->id . '-' : '') . $row->title;
            return $title;
        }
        
        return array();
    }

    function beforeCreate(&$uri)
    {
        // Remove the part after ':' from variables
        if (! is_null($uri->getVar('id')))
            SEFTools::fixVariable($uri, 'id');
        if (! is_null($uri->getVar('catid')))
            SEFTools::fixVariable($uri, 'catid');
        
        if ($uri->getVar('id') == 0)
            $uri->delVar('id');
        
        if ($uri->getVar('w_id') == 0)
            $uri->delVar('w_id');
        
        return;
    }

    function create(&$uri)
    {
        
        $sefConfig = &SEFConfig::getConfig();
        $database = &JFactory::getDBO();
        
        $this->params = &SEFTools::getExtParams('com_weblinks');
        
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $title[] = JoomSEF::_getMenuTitle($option, @$this_task, @$Itemid);
        
        switch (@$view) {
            case 'category':
                $title = array_merge($title, $this->getCategoryTitle(@$id, true));
                break;
            case 'form':
                $title = array_merge($title, $this->getWeblinkTitle(@$w_id));
                $title[] = JText::_('COM_SEF_FORM');
                if (@$layout == 'edit')
                    $title[] = JText::_('COM_SEF_EDIT');
                break;
        }
        
        switch (@$task) {
            case 'weblink.go':
                $title = array_merge($title, $this->getCategoryTitle(@$catid));
                if (@$id)
                    $title = array_merge($title, $this->getWeblinkTitle($id));
                else
                    $title[] = JText::_('COM_SEF_SUBMIT');
                break;
            case 'new':
                $title[] = 'new' . $sefConfig->suffix;
                break;
            case 'weblink.edit':
                $title = array_merge($title, $this->getWeblinkTitle(@$w_id));
                $title[] = JText::_('COM_SEF_EDIT');
                if (@$return)
                    $nonSefVars['return'] = $return;
                break;
        }
        
        if (@$format) {
            if ($format == 'feed' && @$type)
                $title[] = ucfirst($type);
            else
                $title[] = ucfirst($format);
        }
        
        $newUri = $uri;
        if (count($title)) {
            // Generate meta tags
            $metatags = $this->getMetaTags();
            
            $priority = $this->getPriority($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$vars['lang'], @$nonSefVars, null, $metatags, $priority);
        }
        
        return $newUri;
    }

    function getPriority(&$uri)
    {
        $itemid = $uri->getVar('Itemid');
        $view = $uri->getVar('view');
        
        switch ($view) {
            case 'weblink':
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_WEBLINKS_LINK;
                } else {
                    return _COM_SEF_PRIORITY_WEBLINKS_LINK_ITEMID;
                }
                break;
            
            case 'category':
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_WEBLINKS_CATEGORY;
                } else {
                    return _COM_SEF_PRIORITY_WEBLINKS_CATEGORY_ITEMID;
                }
                break;
            
            default:
                return null;
        }
    }
}

?>
