<?php
/**
 * Contacts SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

define('_COM_SEF_PRIORITY_CONTACT_CONTACT_ITEMID', 15);
define('_COM_SEF_PRIORITY_CONTACT_CONTACT', 20);
define('_COM_SEF_PRIORITY_CONTACT_CATEGORY_ITEMID', 25);
define('_COM_SEF_PRIORITY_CONTACT_CATEGORY', 30);

jimport('joomla.application.categories');

class SefExt_com_contact extends SefExt
{

    function getCategories($id)
    {
        $categories = JCategories::getInstance('Contact');
        $cat = $categories->get($id);
        
        $ret = array();
        $field = 'title';
        if (SEFTools::UseAlias($this->params, 'category_alias')) {
            $field = 'alias';
        }
        
        while (! is_null($cat) && ($cat->id != 'root')) {
            $name = (($this->params->get('categoryid', '0') != '0') ? $cat->id . '-' : '') . $cat->$field;
            array_unshift($ret, $name);
            
            if (is_null($this->metadesc)) {
                $this->metadesc = $cat->description;
            }
            
            $cat = $cat->getParent();
        }
        
        return $ret;
    }

    function getContactName($id)
    {
        $database = & JFactory::getDBO();
        $sefConfig = & SEFConfig::getConfig();
        
        $field = 'name';
        if (SEFTools::UseAlias($this->params, 'contact_alias')) {
            $field = 'alias';
        }
        
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';
        $database->setQuery("SELECT `$field` AS `name`, `catid`, `misc` $jfTranslate FROM `#__contact_details` WHERE `id` = $id");
        $contact = $database->loadObject();
        
        if ($contact) {
            
            $name = (($this->params->get('contactid', '0') != '0') ? $id . '-' : '') . $contact->name;
            
            // use contact description as page meta tags if available
            if (($contact->misc = JString::trim($contact->misc)))
                $this->metadesc = $contact->misc;
            
            if ($this->params->get('categories', '2') == '0') {
                return array($name);
            } else {
                $cats = $this->getCategories($contact->catid);
                if ($this->params->get('categories', '2') == '1') {
                    return array(array_pop($cats) , $name);
                } else {
                    array_push($cats, $name);
                    return $cats;
                }
            }
        } else {
            return array();
        }
    }

    function beforeCreate(&$uri)
    {
        // Remove the part after ':' from variables
        if (! is_null($uri->getVar('id')))
            SEFTools::fixVariable($uri, 'id');
        if (! is_null($uri->getVar('catid')))
            SEFTools::fixVariable($uri, 'catid');
        
        $view = $uri->getVar('view');
        $id = (int) $uri->getVar('id');
        $catid = (int) $uri->getVar('catid');
        
        switch ($view) {
            case 'category':
            case 'categories':
                // Remove view and catid if they point to empty category/categories
                if (! $id) {
                    $uri->delVar('view');
                    $uri->delVar('id');
                }
            case 'contact':
                if ($id && $catid)
                    $uri->delVar('catid');
        }
        
        return;
    }

    function create(&$uri)
    {
        $this->metadesc = null;
        
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $this->params = SEFTools::getExtParams('com_contact');
        
        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
        
        if (isset($view)) {
            switch ($view) {
                case 'contact':
                    $title = array_merge($title, $this->getContactName($id));
                    break;
                default:
                    if (isset($id)) {
                        $cats = $this->getCategories($id);
                        if ($this->params->get('categories', '2') == '2')
                            $title = array_merge($title, $cats);
                        else
                            $title[] = array_pop($cats);
                    }
                    break;
            }
            switch ($view) {
                case 'contact':
                case 'featured':
                case 'category':
                case 'categories':
                    unset($view);
                    break;
            }
        }
        
        if (! empty($format) && ($format == 'feed')) {
            if (! empty($type))
                $title[] = $type;
        }
        
        $newUri = $uri;
        
        if (count($title) > 0) {
            // Generate meta tags
            $metatags = $this->getMetaTags();
            
            $priority = $this->getPriority($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$view, null, null, @$lang, null, null, $metatags, $priority);
        }
        
        return $newUri;
    }

    function getPriority(&$uri)
    {
        $itemid = $uri->getVar('Itemid');
        $view = $uri->getVar('view');
        
        switch ($view) {
            case 'contact':
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_CONTACT_CONTACT;
                } else {
                    return _COM_SEF_PRIORITY_CONTACT_CONTACT_ITEMID;
                }
                break;
            
            default:
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_CONTACT_CATEGORY;
                } else {
                    return _COM_SEF_PRIORITY_CONTACT_CATEGORY_ITEMID;
                }
                break;
        }
    }
}
?>