<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFViewSiteMap extends JView
{
	function display($tpl = null)
	{
	    $icon = 'manage-sitemap.png';
		JToolBarHelper::title(JText::_('COM_SEF_JOOMSEF_SITEMAP_MANAGER'), $icon);
		
        $this->assign($this->getModel());
        $lists =& $this->get('Lists');
        
        $bar =& JToolBar::getInstance();
        
		// Actions
		$bar->appendButton('Custom', $lists['selection']);
		$bar->appendButton('Custom', $lists['actions']);
		$bar->appendButton('Custom', $lists['newdate'] . $lists['newpriority'] . $lists['newfrequency']);
		$bar->appendButton('Custom', '<input type="button" value="'.JText::_('COM_SEF_PROCEED').'" onclick="doAction();" />');
		JToolBarHelper::divider();
		
        JToolBarHelper::save();
        JToolBarHelper::apply();
        JToolBarHelper::spacer();
        JToolBarHelper::custom('generatexml', 'xml', '', 'COM_SEF_GENERATE_XML', false);
        JToolBarHelper::spacer();
        JToolBarHelper::custom('pinggoogle', 'google', '', 'COM_SEF_PING_GOOGLE', false);
        JToolBarHelper::custom('pingyahoo', 'yahoo', '', 'COM_SEF_PING_YAHOO', false);
        JToolBarHelper::custom('pingbing', 'bing', '', 'COM_SEF_PING_BING', false);
        JToolBarHelper::custom('pingservices', 'services', '', 'COM_SEF_PING_SERVICES', false);
        JToolBarHelper::spacer();
        JToolBarHelper::back('COM_SEF_BACK', 'index.php?option=com_sef');
        
		// Get data from the model
        $this->assignRef('items', $this->get('Data'));
        $this->assignRef('total', $this->get('Total'));
        $this->assignRef('lists', $lists);
        $this->assignRef('pagination', $this->get('Pagination'));
        
        // Check the sitemap changed flag
        $sefConfig =& SEFConfig::getConfig();
        $file = JPATH_ROOT.DS.$sefConfig->sitemap_filename.'.xml';
        if ($sefConfig->sitemap_changed || !file_exists($file)) {
            JError::raiseNotice(100, JText::_('COM_SEF_SITEMAP_DEPRECATED'));
        }
        
        JHTML::_('behavior.tooltip');
        
		parent::display($tpl);
	}

}
