<?php
/**
 * Mosets Tree SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_mtree extends SefExt
{
    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('limit')))
            $this->nonSefVars['limit'] = $uri->getVar('limit');
        if (!is_null($uri->getVar('limitstart')))
            $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
        if (!is_null($uri->getVar('search_id')))
            $this->nonSefVars['search_id'] = $uri->getVar('search_id');
        if (!is_null($uri->getVar('searchword')))
            $this->nonSefVars['searchword'] = $uri->getVar('searchword');
    }
    
    /**
     * Helper function to get parent and sub category tree array for building URL
     */
    function mtree_sef_get_category_array($cat_id)
    {
        static $tree = false;
        if (!$tree){
            $db =& JFactory::getDBO();
            $db->setQuery("SELECT cat_name, cat_id, cat_parent FROM #__mt_cats");
            $tree = $db->loadObjectList('cat_id');
        }
        $title = array();
        while ($cat_id != 0) {
            $title[] = $tree[$cat_id]->cat_name;
            $cat_id = $tree[$cat_id]->cat_parent;
        }
        
        return array_reverse($title);
    }

    function mtree_sef_get_category_name($cat_id) {
        $db =& JFactory::getDBO();
        $db->setQuery("SELECT cat_name, cat_id FROM #__mt_cats WHERE cat_id = $cat_id");
        $cat = null;
        $cat = $db->loadObject();
        return (isset($cat->cat_name) ? $cat->cat_name : '');
    }

    function getUserName($id) {
        $database =& JFactory::getDBO();

        $database->setQuery( "SELECT `username` FROM `#__users` WHERE `id` = '$id' AND `block` = '0'" );
        $username = $database->loadResult();
        return $username;
    }

    function create(&$uri) {
        $database =& JFactory::getDBO();
        
        // Load the texts to use in URL
        $tasks = SEFTools::getExtTexts('com_mtree');

        $params = SEFTools::getExtParams('com_mtree');

        /**
         * Use this to get variables from the original Joomla! URL, such as $task, $page, $id, $catID, ...
         */
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);


        /**
         * find cat_id for link_id
         */
        if (!isset($cat_id) && isset($link_id)) {
            // get category tree (parent cat and sub cats)
            $sql = "SELECT cat_id FROM #__mt_cl WHERE link_id=".$link_id;
            $database->setQuery($sql);
            $cat_id = $database->loadResult();
        }

        /**
         * Get category tree (parent cat and sub cats).
         */
        $categories = $params->get('categories', '2');
        if (isset($cat_id) && $cat_id != 0) {
            if( $categories != '0' || !isset($link_id) ) {
                // Remove the component menu title if set to
                if( $params->get('addtitle', '1') != '1' ) {
                    array_shift($title);
                }

                if( $categories == '1' ) {
                    $title[] = $this->mtree_sef_get_category_name($cat_id);
                } else {
                    $title = array_merge($title, $this->mtree_sef_get_category_array($cat_id));
                }
            }
            unset($vars['cat_id']);
        }

        /**
         * Get info for recommend, contact and viewlink links.
         */
        if (isset($link_id)) {
            // get link name (company name)
            $sql  = "SELECT link_name FROM #__mt_links WHERE link_id=".$link_id;
            $database->setQuery($sql);
            if ($link_name = $database->loadResult()) {
                $title[] = $link_name;
            }
            unset($vars['link_id']);
        }

        /**
         * Alphabetical search / filter (a, b, c, d, etc...)
         */
        if (@$task == 'listalpha' && isset($alpha)) {
            $title[] = $alpha;
            unset($vars['alpha']);
            unset($task);
        }
        /**
         * Tag search
         */
        if (@$task == 'searchby') {
            if ( isset($cf_id) ) {
                $database->setQuery( 'SELECT * FROM #__mt_customfields AS cf'
	            . ' WHERE cf.cf_id = ' . $database->Quote($cf_id) . ' AND published = 1 AND tag_search = 1 LIMIT 1');
                $r = $database->loadObject();
        	$title[] = $r->caption;
            } else {
       	        $title[] = 'tag';
            }
            if ( isset($value) ) {
                $title[] = $value;
            }
            unset($task);
        }
        /**
         * Remove the 'listcats.html' url ending. Change it to index.html
         */
        elseif (@$task == 'listcats') {
            unset($task);
        }

        // Remove the viewlink.html ending if set to
        if( (@$task == 'viewlink') && ($params->get('viewlink', '0') == '0') ) {
            unset($task);
        }

        if( isset($task) && in_array($task, array_keys($tasks)) ) {
            $title[] = $tasks[$task];

            switch( $task ) {
                case 'viewimage': {
                    if( isset($img_id) ) {
                        $title[] = $img_id;
                    }
                    break;
                }

                case 'viewowner':
                case 'viewusersreview':
                case 'viewusersfav': {
                    if( isset($user_id) ) {
                        $title[] = $this->getUserName($user_id);
                    }
                    break;
                }

                case 'replyreview':
                case 'reportreview': {
                    if( isset($rev_id) ) {
                        $title[] = $rev_id;
                    }
                    break;
                }

            }

            unset($task);
        }

        /**
         * Pass the title array to the sefGetLocation function.
         */ 
        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);

            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $this->nonSefVars);
        }

        return $newUri;
    }
}
?>
