<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 * @license     Released under the terms of the GNU General Public License
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

$_MAMBOTS->registerFunction('onAfterStart', 'generateSEFMeta');

function generateSEFMeta()
{
    global $mainframe, $database, $mosConfig_MetaKeys, $mosConfig_MetaDesc;

    // Get the mambot's parameters
    $query = "SELECT id FROM #__mambots WHERE element = 'joomsef_metabot' AND folder = 'system'";
    $database->setQuery($query);
    $id = $database->loadResult();
    $mambot = new mosMambot($database);
    $mambot->load($id);
    $params = new mosParameters($mambot->params);
    
    $rewriteKeywords = $params->get('rewrite_keywords');
    $preferTitle = $params->get('prefer_joomsef_title');
       
    // Add metatags if there are any
    if (isset($GLOBALS['sefMetaTags'])) {
        $tags = $GLOBALS['sefMetaTags'];
        
        // Page title
        if (isset($tags['title'])) {
            $mainframe->setPageTitle($tags['title']);
            if ($preferTitle) {
                // Protect our title from rewriting
                $GLOBALS['mosConfig_pagetitles'] = '0';
            }
            unset($tags['title']);
        }
        
        // Description metatag
        if (isset($tags['metadesc'])) {
            if ($mosConfig_MetaDesc) $mosConfig_MetaDesc .= ', ';
            $mosConfig_MetaDesc .= $tags['metadesc'];
            unset($tags['metadesc']);
        }
        
        // Keywords metatag
        if (isset($tags['metakey'])) {
            if( ($rewriteKeywords == '1') || ($mosConfig_MetaKeys == '') ) {
                $mosConfig_MetaKeys = $tags['metakey'];
            }
            else {
                $mosConfig_MetaKeys .= ', ' . $tags['metakey'];
            }
            $mainframe->addMetaTag('keywords', $mosConfig_MetaKeys);
            $mosConfig_MetaKeys = '';
            unset($tags['metakey']);
        }
        
        // Other metatags
        foreach ($tags as $name => $content) {
            $mainframe->appendMetaTag($name, $content);
        }
    }
}
?>
