<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class SefSitemapXmlWriter
{
    /** @var string */
    protected $filePath;

    /** @var resource */
    protected $fileHandle;

    /** @var int */
    protected $urls = 0;

    /**
     * @param string $filePath
     */
    public function __construct($filePath)
    {
        $this->filePath = $filePath;
        $this->openFile();
        $this->writeHeader();
    }

    /**
     * @return string
     */
    public function getFilePath()
    {
        return $this->filePath;
    }

    protected function openFile()
    {
        $this->fileHandle = @fopen($this->filePath, 'w');
        if (!$this->fileHandle)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_CREATE_XML'));
    }

    protected function writeHeader()
    {
        $header = '<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
';
        if (@fwrite($this->fileHandle, $header) === false)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_SAVE_XML'));
    }

    protected function writeFooter()
    {
        if (@fwrite($this->fileHandle, '</urlset>') === false)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_SAVE_XML'));
    }

    /**
     * @param string $domain
     * @param SefSitemapUrl $url
     */
    public function addUrl($domain, $url)
    {
        $sefConfig = SEFConfig::getConfig();

        $sefUrl = str_replace('&', '&amp;', $url->getSefUrl());

        $urlText = "    <url>\n";
        $urlText .= "        <loc>{$domain}{$sefUrl}</loc>\n";
        if ($sefConfig->sitemap_show_date) {
            $urlText .= "        <lastmod>{$url->getSitemapDate()}</lastmod>\n";
        }
        if ($sefConfig->sitemap_show_frequency) {
            $urlText .= "        <changefreq>{$url->getSitemapFrequency()}</changefreq>\n";
        }
        if ($sefConfig->sitemap_show_priority) {
            $urlText .= "        <priority>{$url->getSitemapPriority()}</priority>\n";
        }
        $urlText .= "    </url>\n";

        if (@fwrite($this->fileHandle, $urlText) === false)
            throw new RuntimeException(JText::_('COM_SEF_ERROR_SAVE_XML'));

        $this->urls++;
    }

    /**
     * @return int
     */
    public function getUrlsCount()
    {
        return $this->urls;
    }

    public function close()
    {
        if ($this->fileHandle) {
            $this->writeFooter();

            @fclose($this->fileHandle);
            $this->fileHandle = null;
        }
    }
}
