<?php

/**
 * @version	$Id$
 * @package	Joomla.Administrator
 * @subpackage	JoomDOC
 * @author   	ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license	GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

/**
 * Filter document list for the latest versions.
 * 
 * INSTALLATION
 * copy file into folder
 * administrator/components/com_falang/contentelements
 */
class translationJoomdocversionFilter extends translationFilter
{
    /**
     * (non-PHPdoc)
     * @see translationFilter::_createFilter()
     */
    function _createFilter() {
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	
    	$query->select('MIN(id)');
    	$query->from('#__joomdoc');
    	$query->group('path');
    	
    	$db->setQuery($query);
    	$ids = $db->loadColumn(); // the latest versions of document list
    	
    	$filter = '';
    	if (!empty($ids))
    		$filter = 'c.id IN (' . implode(', ', $ids) . ')'; // filter document list for the latest versions only
    	return $filter;
    }
}