<?php

/**
 * @package        Joomla.Administrator
 * @subpackage    JoomDOC
 * @author      ARTIO, info@artio.net, http:://www.artio.net
 * @copyright    Copyright (C) ARTIO. All rights reserved.
 * @license        GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCAccessLevel
{

    /**
     * Make access level for group and folder with the same title and assign them together.
     * @param string $title group and folder title
     */
    public static function make($title)
    {
        $group = (object)self::getGroup($title);
        $access = (object)self::getAccess($title);
        $document = (object)self::getDocument($title);

        if (!empty($group->id) && !empty($document->id)) {
            if (empty($access->id)) {
                // create access level with the same title and assign with the  group
                $access->id = self::createAccess($title, $group->id);
            }
            // assign the folder and all files included files with the access level
            self::updateAccess($document->path, $access->id);
            self::updateFlat($document->path, $access->id);
        }
    }

    /**
     * Create access level.
     * @param string $title access level title
     * @param int $groupId group to assign
     * @return int access level id
     */
    protected static function createAccess($title, $groupId)
    {
        JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_users/models');
        $model = JModelLegacy::getInstance('Level', 'UsersModel');
        /* @var $model UsersModelLevel */
        $model->save(array('title' => $title, 'rules' => array($groupId)));
        return $model->getState('level.id');
    }

    /**
     * Update access level of folder and all included files.
     * @param string $path folder path
     * @param int $access access level id
     */
    protected static function updateAccess($path, $access)
    {
        $db = JFactory::getDbo();
        $path = $db->q($path);
        $query = $db->getQuery(true)
            ->update('#__joomdoc')
            ->set('access = ' . (int)$access)
            ->where('path = ' . $path . ' OR parent_path = ' . $path);
        $db->setQuery($query)->execute();
    }

    /**
     * Update access level of folder and all included files in flat index.
     * @param string $path folder path
     * @param int $access access level id
     */
    protected static function updateFlat($path, $access)
    {
        $db = JFactory::getDbo();
        $path = $db->q($path);
        $query = $db->getQuery(true)
            ->update('#__joomdoc_flat')
            ->set('access = ' . (int)$access)
            ->where('path = ' . $path . ' OR parent_path = ' . $path);
        $db->setQuery($query)->execute();
    }

    /**
     * Get group by title.
     * @param string $title group title
     * @return int array group data
     */
    protected static function getGroup($title)
    {
        $table = JTable::getInstance('Usergroup', 'JTable');
        /* @var $table JTableUsergroup */
        $table->load(array('title' => $title));
        return $table->getProperties();
    }

    /**
     * Get access level by title.
     * @param string $title access level title
     * @return array access level data
     */
    protected static function getAccess($title)
    {
        $table = JTable::getInstance('Viewlevel', 'JTable');
        /* @var $table JTableViewlevel */
        $table->load(array('title' => $title));
        return $table->getProperties();
    }

    /**
     * Get document by title.
     * @param string $title document title
     * @return array document data
     */
    protected static function getDocument($title)
    {
        JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_joomdoc/tables');
        $table = JTable::getInstance('Flat', 'JoomDOCTable');
        /* @var $table JoomDOCTableFlat */
        $table->load(array('title' => $title));
        return $table->getProperties();
    }
}